    <?php
    // Connect to your MySQL database (replace with your actual database credentials)
    $db = new mysqli('hostname', 'username', 'password', 'database_name');

    // Check for database connection errors
    if ($db->connect_error) {
        die("Database connection failed: " . $db->connect_error);
    }

    // Retrieve platform and search term from the form submission
    $platform = $_POST['platform'];
    $searchTerm = $_POST['search'];

    // Create a SQL query to fetch SMM services based on the filter
    $sql = "SELECT * FROM smm_services WHERE platform = ?";

    // If a search term is provided, add it to the SQL query
    if (!empty($searchTerm)) {
        $sql .= " AND service_name LIKE ?";
    }

    // Prepare and execute the SQL query
    $stmt = $db->prepare($sql);

    if (!empty($searchTerm)) {
        $searchTerm = '%' . $searchTerm . '%'; // Add wildcards for partial matching
        $stmt->bind_param('ss', $platform, $searchTerm);
    } else {
        $stmt->bind_param('s', $platform);
    }

    $stmt->execute();

    // Get the results
    $result = $stmt->get_result();

    // Display the filtered services
    echo '<h2>Filtered Services</h2>';
    while ($row = $result->fetch_assoc()) {
        echo '<p><strong>Platform:</strong> ' . $row['platform'] . '</p>';
        echo '<p><strong>Service Name:</strong> ' . $row['service_name'] . '</p>';
        // Add more details as needed
        echo '<hr>';
    }

    // Close the database connection
    $db->close();
    ?>